﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace OposSample_CSharp
{
    public partial class FuncTest : Form
    {
        #region opos consts


        /////////////////////////////////////////////////////////////////////
        // OPOS "State" Property Constants
        /////////////////////////////////////////////////////////////////////
        const int OPOS_S_CLOSED = 1;
        const int OPOS_S_IDLE = 2;
        const int OPOS_S_BUSY = 3;
        const int OPOS_S_ERROR = 4;


        /////////////////////////////////////////////////////////////////////
        // OPOS "ResultCode" Property Constants
        /////////////////////////////////////////////////////////////////////

        const int OPOS_SUCCESS = 0;
        const int OPOS_E_CLOSED = 101;
        const int OPOS_E_CLAIMED = 102;
        const int OPOS_E_NOTCLAIMED = 103;
        const int OPOS_E_NOSERVICE = 104;
        const int OPOS_E_DISABLED = 105;
        const int OPOS_E_ILLEGAL = 106;
        const int OPOS_E_NOHARDWARE = 107;
        const int OPOS_E_OFFLINE = 108;
        const int OPOS_E_NOEXIST = 109;
        const int OPOS_E_EXISTS = 110;
        const int OPOS_E_FAILURE = 111;
        const int OPOS_E_TIMEOUT = 112;
        const int OPOS_E_BUSY = 113;
        const int OPOS_E_EXTENDED = 114;
        const int OPOS_E_DEPRECATED = 115; // (added in 1.11)

        const int OPOSERR = 100; // Base for ResultCode errors.
        const int OPOSERREXT = 200; // Base for ResultCodeExtendedErrors.

        const int OPOS_EX_NOTSUPPORTED = 300;
        const int OPOS_EX_BADPARAM = 301;
        /////////////////////////////////////////////////////////////////////
        // OPOS "ResultCodeExtended" Property Constants
        /////////////////////////////////////////////////////////////////////

        // The following applies to ResetStatistics and UpdateStatistics.
        const int OPOS_ESTATS_ERROR = 280; // (added in 1.8)
        const int OPOS_ESTATS_DEPENDENCY = 282; // (added in 1.10)
        // The following applies to CompareFirmwareVersion and UpdateFirmware.
        const int OPOS_EFIRMWARE_BAD_FILE = 281; // (added in 1.9)


        /////////////////////////////////////////////////////////////////////
        // OPOS "OpenResult" Property Constants (added in 1.5)
        /////////////////////////////////////////////////////////////////////

        // The following can be set by the control object.
        //  - Control Object already open.
        const int OPOS_OR_ALREADYOPEN = 301;
        //  - The registry does not contain a key for the specified device name.
        const int OPOS_OR_REGBADNAME = 302;
        //  - Could not read the device name key's default value, or
        //     could not convert this Prog ID to a valid Class ID.
        const int OPOS_OR_REGPROGID = 303;
        //  - Could not create a service object instance, or
        //     could not get its IDispatch interface.
        const int OPOS_OR_CREATE = 304;
        //  - The service object does not support one or more of the
        //     method required by its release.
        const int OPOS_OR_BADIF = 305;
        //  - The service object returned a failure status from its
        //     open call, but doesn't have a more specific failure code.
        const int OPOS_OR_FAILEDOPEN = 306;
        //  - The service object major version number is not 1.
        const int OPOS_OR_BADVERSION = 307;

        // The following can be returned by the service object if it
        // returns a failure status from its open call.
        //  - Port access required at open, but configured port
        //     is invalid or inaccessible.
        const int OPOS_ORS_NOPORT = 401;
        //  - Service Object does not support the specified device.
        const int OPOS_ORS_NOTSUPPORTED = 402;
        //  - Configuration information error.
        const int OPOS_ORS_CONFIG = 403;
        //  - Errors greater than this value are SO-specific.
        const int OPOS_ORS_SPECIFIC = 450;


        /////////////////////////////////////////////////////////////////////
        // OPOS "BinaryConversion" Property Constants (added in 1.2)
        /////////////////////////////////////////////////////////////////////

        const int OPOS_BC_NONE = 0;
        const int OPOS_BC_NIBBLE = 1;
        const int OPOS_BC_DECIMAL = 2;


        /////////////////////////////////////////////////////////////////////
        // "CheckHealth" Method: "Level" Parameter Constants
        /////////////////////////////////////////////////////////////////////

        const int OPOS_CH_INTERNAL = 1;
        const int OPOS_CH_EXTERNAL = 2;
        const int OPOS_CH_INTERACTIVE = 3;


        /////////////////////////////////////////////////////////////////////
        // OPOS "CapPowerReporting", "PowerState", "PowerNotify" Property
        //   Constants (added in 1.3)
        /////////////////////////////////////////////////////////////////////

        const int OPOS_PR_NONE = 0;
        const int OPOS_PR_STANDARD = 1;
        const int OPOS_PR_ADVANCED = 2;

        const int OPOS_PN_DISABLED = 0;
        const int OPOS_PN_ENABLED = 1;

        const int OPOS_PS_UNKNOWN = 2000;
        const int OPOS_PS_ONLINE = 2001;
        const int OPOS_PS_OFF = 2002;
        const int OPOS_PS_OFFLINE = 2003;
        const int OPOS_PS_OFF_OFFLINE = 2004;


        /////////////////////////////////////////////////////////////////////
        // "CompareFirmwareVersion" Method: "Result" Parameter Constants
        //   (added in 1.9)
        /////////////////////////////////////////////////////////////////////

        const int OPOS_CFV_FIRMWARE_OLDER = 1;
        const int OPOS_CFV_FIRMWARE_SAME = 2;
        const int OPOS_CFV_FIRMWARE_NEWER = 3;
        const int OPOS_CFV_FIRMWARE_DIFFERENT = 4;
        const int OPOS_CFV_FIRMWARE_UNKNOWN = 5;


        /////////////////////////////////////////////////////////////////////
        // "ErrorEvent" Event: "ErrorLocus" Parameter Constants
        /////////////////////////////////////////////////////////////////////

        const int OPOS_EL_OUTPUT = 1;
        const int OPOS_EL_INPUT = 2;
        const int OPOS_EL_INPUT_DATA = 3;


        /////////////////////////////////////////////////////////////////////
        // "ErrorEvent" Event: "ErrorResponse" Constants
        /////////////////////////////////////////////////////////////////////

        const int OPOS_ER_RETRY = 11;
        const int OPOS_ER_CLEAR = 12;
        const int OPOS_ER_CONTINUEINPUT = 13;


        /////////////////////////////////////////////////////////////////////
        // "StatusUpdateEvent" Event: Common "Status" Constants
        /////////////////////////////////////////////////////////////////////

        const int OPOS_SUE_POWER_ONLINE = 2001; // (added in 1.3)
        const int OPOS_SUE_POWER_OFF = 2002; // (added in 1.3)
        const int OPOS_SUE_POWER_OFFLINE = 2003; // (added in 1.3)
        const int OPOS_SUE_POWER_OFF_OFFLINE = 2004; // (added in 1.3)

        const int OPOS_SUE_UF_PROGRESS = 2100; // (added in 1.9)
        const int OPOS_SUE_UF_COMPLETE = 2200; // (added in 1.9)
        const int OPOS_SUE_UF_COMPLETE_DEV_NOT_RESTORED = 2205; // (added in 1.9)
        const int OPOS_SUE_UF_FAILED_DEV_OK = 2201; // (added in 1.9)
        const int OPOS_SUE_UF_FAILED_DEV_UNRECOVERABLE = 2202; // (added in 1.9)
        const int OPOS_SUE_UF_FAILED_DEV_NEEDS_FIRMWARE = 2203; // (added in 1.9)
        const int OPOS_SUE_UF_FAILED_DEV_UNKNOWN = 2204; // (added in 1.9)


        /////////////////////////////////////////////////////////////////////
        // General Constants
        /////////////////////////////////////////////////////////////////////

        const int OPOS_FOREVER = -1; // (added in 1.2)

        const int PTR_S_JOURNAL = 1;
        const int PTR_S_RECEIPT = 2;
        const int PTR_S_SLIP = 4;

        const int PTR_S_JOURNAL_RECEIPT = 0x0003;
        const int PTR_S_JOURNAL_SLIP = 0x0005;
        const int PTR_S_RECEIPT_SLIP = 0x0006;

        const int PTR_TWO_RECEIPT_JOURNAL = 0x8003; // (added in 1.3)
        const int PTR_TWO_SLIP_JOURNAL = 0x8005; // (added in 1.3)
        const int PTR_TWO_SLIP_RECEIPT = 0x8006; // (added in 1.3)


        /////////////////////////////////////////////////////////////////////
        // "CapCharacterSet" Property Constants (added in 1.1)
        /////////////////////////////////////////////////////////////////////

        const int PTR_CCS_ALPHA = 1;
        const int PTR_CCS_ASCII = 998;
        const int PTR_CCS_KANA = 10;
        const int PTR_CCS_KANJI = 11;
        const int PTR_CCS_UNICODE = 997; // (added in 1.5)


        /////////////////////////////////////////////////////////////////////
        // "CharacterSet" Property Constants
        /////////////////////////////////////////////////////////////////////

        //CH
        const int PTR_CS_CH = 936;


        const int PTR_CS_UNICODE = 997; // (added in 1.5)
        const int PTR_CS_ASCII = 998;
        const int PTR_CS_WINDOWS = 999;
        const int PTR_CS_ANSI = 999;


        /////////////////////////////////////////////////////////////////////
        // "ErrorLevel" Property Constants (added in 1.1)
        /////////////////////////////////////////////////////////////////////

        const int PTR_EL_NONE = 1;
        const int PTR_EL_RECOVERABLE = 2;
        const int PTR_EL_FATAL = 3;


        /////////////////////////////////////////////////////////////////////
        // "MapMode" Property Constants
        /////////////////////////////////////////////////////////////////////

        const int PTR_MM_DOTS = 1;
        const int PTR_MM_TWIPS = 2;
        const int PTR_MM_ENGLISH = 3;
        const int PTR_MM_METRIC = 4;


        /////////////////////////////////////////////////////////////////////
        // "CapXxxColor" Property Constants
        /////////////////////////////////////////////////////////////////////

        const int PTR_COLOR_PRIMARY = 0x00000001;
        const int PTR_COLOR_CUSTOM1 = 0x00000002;
        const int PTR_COLOR_CUSTOM2 = 0x00000004;
        const int PTR_COLOR_CUSTOM3 = 0x00000008;
        const int PTR_COLOR_CUSTOM4 = 0x00000010;
        const int PTR_COLOR_CUSTOM5 = 0x00000020;
        const int PTR_COLOR_CUSTOM6 = 0x00000040;
        const int PTR_COLOR_CYAN = 0x00000100;
        const int PTR_COLOR_MAGENTA = 0x00000200;
        const int PTR_COLOR_YELLOW = 0x00000400;
        const long PTR_COLOR_FULL = 0x80000000;


        /////////////////////////////////////////////////////////////////////
        // "CapXxxCartridgeSensor" and  "XxxCartridgeState" Property Constants
        //   (added in 1.5)
        /////////////////////////////////////////////////////////////////////

        const int PTR_CART_UNKNOWN = 0x10000000;
        const int PTR_CART_OK = 0x00000000;
        const int PTR_CART_REMOVED = 0x00000001;
        const int PTR_CART_EMPTY = 0x00000002;
        const int PTR_CART_NEAREND = 0x00000004;
        const int PTR_CART_CLEANING = 0x00000008;


        /////////////////////////////////////////////////////////////////////
        // "CartridgeNotify" Property Constants (added in 1.5)
        /////////////////////////////////////////////////////////////////////

        const int PTR_CN_DISABLED = 0x00000000;
        const int PTR_CN_ENABLED = 0x00000001;


        /////////////////////////////////////////////////////////////////////
        // "PageModeDescriptor" Property Constants (added in 1.9)
        /////////////////////////////////////////////////////////////////////

        const int PTR_PM_BITMAP = 0x00000001;
        const int PTR_PM_BARCODE = 0x00000002;
        const int PTR_PM_BM_ROTATE = 0x00000004;
        const int PTR_PM_BC_ROTATE = 0x00000008;
        const int PTR_PM_OPAQUE = 0x00000010;


        /////////////////////////////////////////////////////////////////////
        // "PageModePrintDirection" Property Constants (added in 1.9)
        /////////////////////////////////////////////////////////////////////

        const int PTR_PD_LEFT_TO_RIGHT = 1;
        const int PTR_PD_BOTTOM_TO_TOP = 2;
        const int PTR_PD_RIGHT_TO_LEFT = 3;
        const int PTR_PD_TOP_TO_BOTTOM = 4;


        /////////////////////////////////////////////////////////////////////
        // "CutPaper" Method Constant
        /////////////////////////////////////////////////////////////////////

        const int PTR_CP_PARTIALCUT = 75;
        const int PTR_CP_FULLCUT = 100;


        /////////////////////////////////////////////////////////////////////
        // "PageModePrint" Method: "Control" Parameter Constants (added in 1.9)
        /////////////////////////////////////////////////////////////////////

        const int PTR_PM_PAGE_MODE = 1;
        const int PTR_PM_PRINT_SAVE = 2;
        const int PTR_PM_NORMAL = 3;
        const int PTR_PM_CANCEL = 4;


        /////////////////////////////////////////////////////////////////////
        // "PrintBarCode" Method Constants:
        /////////////////////////////////////////////////////////////////////

        //** "Alignment" Parameter
        //     Either the distance from the left-most print column to the start
        //     of the bar code, or one of the following:

        const int PTR_BC_LEFT = -1;
        const int PTR_BC_CENTER = -2;
        const int PTR_BC_RIGHT = -3;

        //** "TextPosition" Parameter

        const int PTR_BC_TEXT_NONE = -11;
        const int PTR_BC_TEXT_ABOVE = -12;
        const int PTR_BC_TEXT_BELOW = -13;

        //** "Symbology" Parameter:

        //    - One dimensional symbologies
        const int PTR_BCS_UPCA = 101;  // Digits
        const int PTR_BCS_UPCE = 102;  // Digits
        const int PTR_BCS_JAN8 = 103;  // = EAN 8
        const int PTR_BCS_EAN8 = 103;  // = JAN 8 (added in 1.2)
        const int PTR_BCS_JAN13 = 104;  // = EAN 13
        const int PTR_BCS_EAN13 = 104;  // = JAN 13 (added in 1.2)
        const int PTR_BCS_TF = 105;  // (Discrete 2 of 5) Digits
        const int PTR_BCS_ITF = 106;  // (Interleaved 2 of 5) Digits
        const int PTR_BCS_Codabar = 107;  // Digits, -, $, :, /, ., +;
        //   4 start/stop characters
        //   (a, b, c, d)
        const int PTR_BCS_Code39 = 108;  // Alpha, Digits, Space, -, .,
        //   $, /, +, %; start/stop (*)
        // Also has Full ASCII feature
        const int PTR_BCS_Code93 = 109;  // Same characters as Code 39
        const int PTR_BCS_Code128 = 110;  // 128 data characters

        //    - One dimensional symbologies (added in 1.2)
        const int PTR_BCS_UPCA_S = 111;  // UPC-A with supplemental
        //   barcode
        const int PTR_BCS_UPCE_S = 112;  // UPC-E with supplemental
        //   barcode
        const int PTR_BCS_UPCD1 = 113;  // UPC-D1
        const int PTR_BCS_UPCD2 = 114;  // UPC-D2
        const int PTR_BCS_UPCD3 = 115;  // UPC-D3
        const int PTR_BCS_UPCD4 = 116;  // UPC-D4
        const int PTR_BCS_UPCD5 = 117;  // UPC-D5
        const int PTR_BCS_EAN8_S = 118;  // EAN 8 with supplemental
        //   barcode
        const int PTR_BCS_EAN13_S = 119;  // EAN 13 with supplemental
        //   barcode
        const int PTR_BCS_EAN128 = 120;  // EAN 128
        const int PTR_BCS_OCRA = 121;  // OCR "A"
        const int PTR_BCS_OCRB = 122;  // OCR "B"

        //    - One dimensional symbologies (added in 1.8)
        const int PTR_BCS_Code128_Parsed = 123;  // Code 128 with parsing
        //        The following RSS constants deprecated in 1.12.
        //        Instead use the GS1DATABAR constants below.
        const int PTR_BCS_RSS14 = 131;  // Reduced Space Symbology - 14 digit GTIN
        const int PTR_BCS_RSS_EXPANDED = 132;  // RSS - 14 digit GTIN plus additional fields

        //    - One dimensional symbologies (added in 1.12)
        const int PTR_BCS_GS1DATABAR = 131;  // GS1 DataBar Omnidirectional
        const int PTR_BCS_GS1DATABAR_E = 132;  // GS1 DataBar Expanded
        const int PTR_BCS_GS1DATABAR_S = 133;  // GS1 DataBar Stacked Omnidirectional
        const int PTR_BCS_GS1DATABAR_E_S = 134;  // GS1 DataBar Expanded Stacked

        //    - Two dimensional symbologies
        const int PTR_BCS_PDF417 = 201;
        const int PTR_BCS_MAXICODE = 202;

        //    - Two dimensional symbologies (added in 1.13)
        const int PTR_BCS_DATAMATRIX = 203;  // Data Matrix
        const int PTR_BCS_QRCODE = 204;  // QR Code
        const int PTR_BCS_UQRCODE = 205;  // Micro QR Code
        const int PTR_BCS_AZTEC = 206;  // Aztec
        const int PTR_BCS_UPDF417 = 207;  // Micro PDF 417

        //    - Start of Printer-Specific bar code symbologies
        const int PTR_BCS_OTHER = 501;


        /////////////////////////////////////////////////////////////////////
        // "PrintBitmap" and "PrintMemoryBitmap" Method Constants:
        /////////////////////////////////////////////////////////////////////

        //** "Width" Parameter
        //     Either bitmap width or:

        const int PTR_BM_ASIS = -11;  // One pixel per printer dot

        //** "Alignment" Parameter
        //     Either the distance from the left-most print column to the start
        //     of the bitmap, or one of the following:

        const int PTR_BM_LEFT = -1;
        const int PTR_BM_CENTER = -2;
        const int PTR_BM_RIGHT = -3;

        //** "Type" Parameter ("PrintMemoryBitmap" only)
        const int PTR_BMT_BMP = 1;
        const int PTR_BMT_JPEG = 2;
        const int PTR_BMT_GIF = 3;


        /////////////////////////////////////////////////////////////////////
        // "RotatePrint" Method: "Rotation" Parameter Constants
        // "RotateSpecial" Property Constants
        /////////////////////////////////////////////////////////////////////

        const int PTR_RP_NORMAL = 0x0001;
        const int PTR_RP_RIGHT90 = 0x0101;
        const int PTR_RP_LEFT90 = 0x0102;
        const int PTR_RP_ROTATE180 = 0x0103;

        // For "RotatePrint", one or both of the following values may be
        // ORed with one of the above values.
        const int PTR_RP_BARCODE = 0x1000; // (added in 1.7)
        const int PTR_RP_BITMAP = 0x2000; // (added in 1.7)


        /////////////////////////////////////////////////////////////////////
        // "SetLogo" Method: "Location" Parameter Constants
        /////////////////////////////////////////////////////////////////////

        const int PTR_L_TOP = 1;
        const int PTR_L_BOTTOM = 2;


        /////////////////////////////////////////////////////////////////////
        // "TransactionPrint" Method: "Control" Parameter Constants (added in 1.1)
        /////////////////////////////////////////////////////////////////////

        const int PTR_TP_TRANSACTION = 11;
        const int PTR_TP_NORMAL = 12;


        /////////////////////////////////////////////////////////////////////
        // "MarkFeed" Method: "Type" Parameter Constants (added in 1.5)
        // "CapRecMarkFeed" Property Constants (added in 1.5)
        /////////////////////////////////////////////////////////////////////

        const int PTR_MF_TO_TAKEUP = 1;
        const int PTR_MF_TO_CUTTER = 2;
        const int PTR_MF_TO_CURRENT_TOF = 4;
        const int PTR_MF_TO_NEXT_TOF = 8;


        /////////////////////////////////////////////////////////////////////
        // "ChangePrintSide" Method: "Side" Parameter Constants (added in 1.5)
        /////////////////////////////////////////////////////////////////////

        const int PTR_PS_UNKNOWN = 0;
        const int PTR_PS_SIDE1 = 1;
        const int PTR_PS_SIDE2 = 2;
        const int PTR_PS_OPPOSITE = 3;


        /////////////////////////////////////////////////////////////////////
        // "CapRecRuledLine" and "CapSlpRuledLine" Property Constants
        // "DrawRuledLine" Method: "LineDirection" Parameter Constants
        // (added in 1.13)
        /////////////////////////////////////////////////////////////////////

        const int PTR_RL_HORIZONTAL = 1;
        const int PTR_RL_VERTICAL = 2;


        /////////////////////////////////////////////////////////////////////
        // "DrawRuledLine" Method: "LineStyle" Parameter Constants
        // (added in 1.13)
        /////////////////////////////////////////////////////////////////////

        const int PTR_LS_SINGLE_SOLID_LINE = 1;
        const int PTR_LS_DOUBLE_SOLID_LINE = 2;
        const int PTR_LS_BROKEN_LINE = 3;
        const int PTR_LS_CHAIN_LINE = 4;


        /////////////////////////////////////////////////////////////////////
        // "StatusUpdateEvent" Event: "Data" Parameter Constants
        /////////////////////////////////////////////////////////////////////

        const int PTR_SUE_COVER_OPEN = 11;
        const int PTR_SUE_COVER_OK = 12;
        const int PTR_SUE_JRN_COVER_OPEN = 60;  // (added in 1.8)
        const int PTR_SUE_JRN_COVER_OK = 61;  // (added in 1.8)
        const int PTR_SUE_REC_COVER_OPEN = 62;  // (added in 1.8)
        const int PTR_SUE_REC_COVER_OK = 63;  // (added in 1.8)
        const int PTR_SUE_SLP_COVER_OPEN = 64;  // (added in 1.8)
        const int PTR_SUE_SLP_COVER_OK = 65;  // (added in 1.8)

        const int PTR_SUE_JRN_EMPTY = 21;
        const int PTR_SUE_JRN_NEAREMPTY = 22;
        const int PTR_SUE_JRN_PAPEROK = 23;

        const int PTR_SUE_REC_EMPTY = 24;
        const int PTR_SUE_REC_NEAREMPTY = 25;
        const int PTR_SUE_REC_PAPEROK = 26;

        const int PTR_SUE_SLP_EMPTY = 27;
        const int PTR_SUE_SLP_NEAREMPTY = 28;
        const int PTR_SUE_SLP_PAPEROK = 29;

        const int PTR_SUE_JRN_CARTRIDGE_EMPTY = 41; // (added in 1.5)
        const int PTR_SUE_JRN_CARTRIDGE_NEAREMPTY = 42; // (added in 1.5)
        const int PTR_SUE_JRN_HEAD_CLEANING = 43; // (added in 1.5)
        const int PTR_SUE_JRN_CARTRIDGE_OK = 44; // (added in 1.5)

        const int PTR_SUE_REC_CARTRIDGE_EMPTY = 45; // (added in 1.5)
        const int PTR_SUE_REC_CARTRIDGE_NEAREMPTY = 46; // (added in 1.5)
        const int PTR_SUE_REC_HEAD_CLEANING = 47; // (added in 1.5)
        const int PTR_SUE_REC_CARTRIDGE_OK = 48; // (added in 1.5)

        const int PTR_SUE_SLP_CARTRIDGE_EMPTY = 49; // (added in 1.5)
        const int PTR_SUE_SLP_CARTRIDGE_NEAREMPTY = 50; // (added in 1.5)
        const int PTR_SUE_SLP_HEAD_CLEANING = 51; // (added in 1.5)
        const int PTR_SUE_SLP_CARTRIDGE_OK = 52; // (added in 1.5)

        const int PTR_SUE_IDLE = 1001;


        /////////////////////////////////////////////////////////////////////
        // "ResultCodeExtended" Property Constants
        /////////////////////////////////////////////////////////////////////

        const int OPOS_EPTR_COVER_OPEN = 201; // (Several)
        const int OPOS_EPTR_JRN_EMPTY = 202; // (Several)
        const int OPOS_EPTR_REC_EMPTY = 203; // (Several)
        const int OPOS_EPTR_SLP_EMPTY = 204; // (Several)
        const int OPOS_EPTR_SLP_FORM = 205; // EndRemoval
        const int OPOS_EPTR_TOOBIG = 206; // PrintBitmap
        const int OPOS_EPTR_BADFORMAT = 207; // PrintBitmap
        const int OPOS_EPTR_JRN_CARTRIDGE_REMOVED = 208; // (Several) (added in 1.5)
        const int OPOS_EPTR_JRN_CARTRIDGE_EMPTY = 209; // (Several) (added in 1.5)
        const int OPOS_EPTR_JRN_HEAD_CLEANING = 210; // (Several) (added in 1.5)
        const int OPOS_EPTR_REC_CARTRIDGE_REMOVED = 211; // (Several) (added in 1.5)
        const int OPOS_EPTR_REC_CARTRIDGE_EMPTY = 212; // (Several) (added in 1.5)
        const int OPOS_EPTR_REC_HEAD_CLEANING = 213; // (Several) (added in 1.5)
        const int OPOS_EPTR_SLP_CARTRIDGE_REMOVED = 214; // (Several) (added in 1.5)
        const int OPOS_EPTR_SLP_CARTRIDGE_EMPTY = 215; // (Several) (added in 1.5)
        const int OPOS_EPTR_SLP_HEAD_CLEANING = 216; // (Several) (added in 1.5)

        const int CASH_SUE_DRAWERCLOSED = 0;
        const int CASH_SUE_DRAWEROPEN = 1;

        #endregion

        bool isOpenedPrinter,isOpenedCashDrawer;
        OposPOSPrinter_CCO.OPOSPOSPrinter posprinter1;
        OposCashDrawer_CCO.OPOSCashDrawer cashdrawer1;

        string strPrinter = "";
        string strCashDrawer = "";
        bool is58printer = false;
        public FuncTest(string _strPrinter, string _strCashDrawer, out int result)
        {
            InitializeComponent();

            isOpenedPrinter = false;
            isOpenedCashDrawer = false;
            strPrinter = _strPrinter;
            strCashDrawer = _strCashDrawer;
            posprinter1 = new OposPOSPrinter_CCO.OPOSPOSPrinter();
            cashdrawer1 = new OposCashDrawer_CCO.OPOSCashDrawer();
            posprinter1.OutputCompleteEvent += new OposPOSPrinter_CCO._IOPOSPOSPrinterEvents_OutputCompleteEventEventHandler(posprinter1_OutputCompleteEvent);
            posprinter1.StatusUpdateEvent += new OposPOSPrinter_CCO._IOPOSPOSPrinterEvents_StatusUpdateEventEventHandler(printer_StatusUpdateEvent);
            cashdrawer1.StatusUpdateEvent += new OposCashDrawer_CCO._IOPOSCashDrawerEvents_StatusUpdateEventEventHandler(cashdrawer_StatusUpdateEvent);

            result = OpenOposPrinter(strPrinter);
            result = OpenOposCashDrawer(strCashDrawer);
        }

        private int OpenOposPrinter(string strPrinter)
        {
            int open_error = OPOS_SUCCESS;
            if (!isOpenedPrinter)
            {
                posprinter1.Open(strPrinter);
                if (posprinter1.ResultCode!= OPOS_SUCCESS)
                {
                    open_error = posprinter1.OpenResult;
                    string error_info = open_error.ToString().Trim();
                    switch (open_error)
                    {
                        case 301:
                            error_info = "Control Object already open";
                            break;
                        case 302:
                            error_info = "The registry does not contain a key for the specified device name";
                            break;
                        case 303:
                            error_info = "Could not read the device name key's default value, or could not convert this Prog ID to a valid Class ID";
                            break;
                        case 304:
                            error_info = "Could not create a service object instance";
                            break;
                        case 305:
                            error_info = "The service object does not support one or more of the method required by its release";
                            break;
                        case 306:
                            error_info = "The service object returned a failure status";
                            break;
                        case 307:
                            error_info = "The service object major version number is not 1";
                            break;
                        case 401:
                            error_info = "Configured port is invalid or inaccessible";
                            break;
                        case 402:
                            error_info = "Does not support the specified device";
                            break;
                        case 403:
                            error_info = "Configuration information error";   
                            break;
                        default:
                            break;
                    }
                    MessageBox.Show("PosPrinter Failed Open: " + error_info + "!");
                    return open_error;
                }
                posprinter1.ClaimDevice(1000);
                if (posprinter1.ResultCode != OPOS_SUCCESS)
                {
                    MessageBox.Show("Fails to get the exclusive right for the device.");
                    return open_error;
                }
                posprinter1.DeviceEnabled=true;
                if (posprinter1.ResultCode != OPOS_SUCCESS)
                {
                    MessageBox.Show("Fails to get the exclusive right for the device.");
                    return open_error;
                }
                else
                {
                    posprinter1.SetBitmap(01, PTR_S_RECEIPT, "LOGO.bmp", PTR_BM_ASIS, PTR_BM_CENTER);
                }
                isOpenedPrinter = true;
            }
            return open_error;
        }
        private void CloseOposPrinter()
        {
            if(isOpenedPrinter)
            {
                posprinter1.DeviceEnabled = false;
                posprinter1.ReleaseDevice();
                posprinter1.Close();
                isOpenedPrinter = false;
            }
        }
        private int OpenOposCashDrawer(string strCashDrawer)
        {
            int nResult = OPOS_SUCCESS;

            if (!isOpenedCashDrawer)
            {
                nResult = cashdrawer1.Open(strCashDrawer);
                if (cashdrawer1.ResultCode != OPOS_SUCCESS)
                {
                    int open_error = cashdrawer1.OpenResult;
                    string error_info = "";
                    switch (open_error)
                    {
                        case 301:
                            error_info = "Control Object already open";
                            break;
                        case 302:
                            error_info = "The registry does not contain a key for the specified device name";
                            break;
                        case 303:
                            error_info = "Could not read the device name key's default value, or could not convert this Prog ID to a valid Class ID";
                            break;
                        case 304:
                            error_info = "Could not create a service object instance";
                            break;
                        case 305:
                            error_info = "The service object does not support one or more of the method required by its release";
                            break;
                        case 306:
                            error_info = "The service object returned a failure status";
                            break;
                        case 307:
                            error_info = "The service object major version number is not 1";
                            break;
                        case 401:
                            error_info = "Configured port is invalid or inaccessible";
                            break;
                        case 402:
                            error_info = "Does not support the specified device";
                            break;
                        case 403:
                            error_info = "Configuration information error";
                            break;
                        default:
                            error_info = "OpenResult:" + open_error.ToString().Trim();
                            break;
                    }
                    MessageBox.Show("Cashdrawer failed to open: " + error_info + "!");
                    return nResult;
                }
                cashdrawer1.ClaimDevice(1000);
                if (cashdrawer1.ResultCode != OPOS_SUCCESS)
                {
                    MessageBox.Show("Cashdrawer failed to get the exclusive right for the device.");
                    return nResult;
                }
                cashdrawer1.DeviceEnabled = true;
                if (cashdrawer1.ResultCode != OPOS_SUCCESS)
                {
                    MessageBox.Show("Cashdrawer failed to get the exclusive right for the device.");
                    return nResult;
                }
                if (!cashdrawer1.CapStatus)
                    this.btnQueryDrawerStatus.Enabled = false;
                isOpenedCashDrawer = true;
            }
            return nResult;
        }
        private void CloseOposCashDrawer()
        {
            if (isOpenedCashDrawer)
            {
                cashdrawer1.DeviceEnabled = false;
                cashdrawer1.ReleaseDevice();
                cashdrawer1.Close();
                isOpenedCashDrawer = false;
            }
        }
        String ESC = "\x1b";
        private void Do(object sender, EventArgs e)
        {
            
            if (!isOpenedPrinter)
            {
                OpenOposPrinter(strPrinter);
                if (!isOpenedPrinter)
                {
                    MessageBox.Show("Cann't print anything due to printer fail!");
                    return;
                }
            }
            if (sender == this.btnCheckHealth)
            {
                posprinter1.CheckHealth(OPOS_CH_INTERACTIVE);
                this.lblInfo.Text = posprinter1.CheckHealthText;
                MessageBox.Show(this.lblInfo.Text);
            }
            else if (sender == this.btnCutPaper)
            {
                posprinter1.CutPaper(PTR_CP_PARTIALCUT);
                this.lblInfo.Text = "CutPaper .";
                MessageBox.Show("CutPaper.");
            }
            else if (sender == this.btnPrintNormal)
            {
                posprinter1.TransactionPrint(PTR_S_RECEIPT, PTR_TP_TRANSACTION);
                posprinter1.SetLogo(PTR_L_TOP, ESC + "|cA" + ESC + "|1B");
                posprinter1.SetLogo(PTR_L_BOTTOM, ESC + "|50uF" + ESC + "|cA" + ESC + "|1B" + ESC + "|uC" + ESC + "|2C" + "It's Bottom Log.\n");
                //doc start
                posprinter1.PrintNormal(PTR_S_RECEIPT, "ESC|tL:\n");
                posprinter1.PrintNormal(PTR_S_RECEIPT, ESC + "|tL\n");
                // text formate sample
                posprinter1.PrintNormal(PTR_S_RECEIPT, "ESC|bC:" + ESC + "|bCSampleCode\n");
                posprinter1.PrintNormal(PTR_S_RECEIPT, "ESC|bC:" + ESC + "|bCSampleCode\n");
                posprinter1.PrintNormal(PTR_S_RECEIPT, "ESC|!bC:" + ESC + "|!bCSampleCode\n");
                posprinter1.PrintNormal(PTR_S_RECEIPT, "ESC|uC:" + ESC + "|uCSampleCode\n");
                posprinter1.PrintNormal(PTR_S_RECEIPT, "ESC|!uC:" + ESC + "|!uCSampleCode\n");
                posprinter1.PrintNormal(PTR_S_RECEIPT, "ESC|1C:" + ESC + "|1CSampleCode\n");
                posprinter1.PrintNormal(PTR_S_RECEIPT, "ESC|2C:" + ESC + "|2CSampleCode\n");
                posprinter1.PrintNormal(PTR_S_RECEIPT, "ESC|3C:" + ESC + "|3CSampleCode\n");
                posprinter1.PrintNormal(PTR_S_RECEIPT, "ESC|4C:" + ESC + "|4CSampleCode\n");
                posprinter1.PrintNormal(PTR_S_RECEIPT, "ESC|rvC:" + ESC + "|rvCSampleCode\n");
                posprinter1.PrintNormal(PTR_S_RECEIPT, "ESC|N:" + ESC + "|N Normal\n");

                //default 
                posprinter1.PrintNormal(PTR_S_RECEIPT, "Default CodePage:" + posprinter1.CharacterSet.ToString() + "\n");
                posprinter1.PrintNormal(PTR_S_RECEIPT, "Text:" + txtPrintNormal.Text + "\n");
                //doc end
                posprinter1.PrintNormal(PTR_S_RECEIPT, "ESC|bL:\n");
                posprinter1.PrintNormal(PTR_S_RECEIPT, ESC + "|bL");
                posprinter1.PrintNormal(PTR_S_RECEIPT, "ESC|fP\n" + ESC + "|90fP");
                posprinter1.TransactionPrint(PTR_S_RECEIPT, PTR_TP_NORMAL);

                this.lblInfo.Text = "Print sample style text.";
                MessageBox.Show("Print sample style text.");
            }
            else if(sender==this.btnPrintBarcode)
            {
                int bcHeight = 50, bcWidth = 3;
                string bcData = "123456789012";

                posprinter1.PrintNormal(PTR_S_RECEIPT, "Code128 Auto:" + bcData + ((char)10).ToString());
                posprinter1.PrintBarCode(PTR_S_RECEIPT,
                                           bcData,
                                           PTR_BCS_Code128,
                                           bcHeight,
                                           bcWidth,
                                           PTR_BC_LEFT,
                                           PTR_BC_TEXT_BELOW);
                bcData = "1234567890abcdefghijklmnopqrstuvwxyzabcd";
                posprinter1.PrintNormal(PTR_S_RECEIPT, "QRCode:" + bcData + ((char)10).ToString());
                posprinter1.PrintBarCode(PTR_S_RECEIPT,
                                           bcData,
                                           PTR_BCS_QRCODE,
                                           200,
                                           200,
                                           PTR_BC_CENTER,
                                           PTR_BC_TEXT_BELOW);
                this.lblInfo.Text = "Print Barcode sample.";
                MessageBox.Show("Print Barcode sample.");
            }
            else if (sender == this.btnPrintImage)
            {
                // 直接打印位图
                posprinter1.PrintBitmap(PTR_S_RECEIPT, "opos.bmp", PTR_BM_ASIS, PTR_BM_LEFT);
                posprinter1.PrintBitmap(PTR_S_RECEIPT, "opos.bmp", 200, PTR_BM_CENTER);

                //posprinter1.PrintNormal(PTR_S_RECEIPT, ESC + "|fP");
                this.lblInfo.Text = "Print LOGO.bmp .";
                MessageBox.Show("Print program_install_path\\opos.bmp .");
            }
            else if (sender == this.btnTransaction)
            {
                this.lblInfo.Text = "Transaction in  progressing...";

	            double tPrice;
	            int i;
	            int iRLineChars;
	            String fDate;
	            String BcData;
	            String sBuf;
	            String sPrice;
                string[] aName = new string[5];
                float[] aPrice = new float[5];

                // Initialization
	            fDate = System.DateTime.Now.ToString("yyyy-MM-dd");
	            BcData = "12345678901234567890";

                // Make a data of the buying goods
                aName[0] = "apples"; aPrice[0] = 10;
                aName[1] = "grapes"; aPrice[1] = 20;
                aName[2] = "bananas"; aPrice[2] = 30;
                aName[3] = "lemons"; aPrice[3] = 40;
                aName[4] = "oranges"; aPrice[4] = 50;

                posprinter1.TransactionPrint(PTR_S_RECEIPT, PTR_TP_TRANSACTION);
                if (posprinter1.CapRecBitmap)
                    posprinter1.PrintNormal(PTR_S_RECEIPT, ESC + "|cA" + ESC + "|1B");


                posprinter1.PrintNormal(PTR_S_RECEIPT, ESC + "|N" + "123xxstreet,xxxcity,xxxxstate \n");
                posprinter1.PrintNormal(PTR_S_RECEIPT, ESC + "|rA" + "TEL 9999-99-9999   C#2\n");
                posprinter1.PrintNormal(PTR_S_RECEIPT, ESC + "|20uF");
                posprinter1.PrintNormal(PTR_S_RECEIPT, ESC + "|cA" + fDate + "\n");
                posprinter1.PrintNormal(PTR_S_RECEIPT, ESC + "|30uF");
                //Print buying goods
                iRLineChars = posprinter1.RecLineChars;
                tPrice = 0.0;

                for (i = 0; i < 5; i++)
                {
                    tPrice += aPrice[i];
                    sPrice = aPrice[i].ToString("$#.00");
                    posprinter1.PrintNormal(PTR_S_RECEIPT, aName[i] + ESC + "|rA" + sPrice + "\n");

                }
                posprinter1.PrintNormal(PTR_S_RECEIPT, ESC + "|100uF");

                //Print the total cost
                sBuf = "Before adding tax";
                sPrice = tPrice.ToString("$#.00");
                posprinter1.PrintNormal(PTR_S_RECEIPT, sBuf + ESC + "|rA" + sPrice + "\n");
                sBuf = "tax   5.0%";
                string sSpace = "";
                sSpace = sSpace.PadLeft(iRLineChars - (sBuf.Length + sPrice.Length), ' ');
                posprinter1.PrintNormal(PTR_S_RECEIPT, ESC + "|uC" + sBuf + sSpace + ESC + "|rA" + sPrice + "\n");
                sBuf = "total";
                sPrice = (tPrice * 1.05).ToString("$#.00");
                posprinter1.PrintNormal(PTR_S_RECEIPT, ESC + "|bC" + ESC + "|2C" + sBuf + ESC + "|rA" + sPrice + "\n");
                sBuf = "Customer's payment";
                sPrice = 200.ToString("$#.00");
                posprinter1.PrintNormal(PTR_S_RECEIPT, sBuf + ESC + "|rA" + sPrice + "\n");
                sBuf = "Change";
                sPrice = (200 - tPrice * 1.05).ToString("$#.00");
                posprinter1.PrintNormal(PTR_S_RECEIPT, sBuf + ESC + "|rA" + sPrice + "\n");
                posprinter1.PrintNormal(PTR_S_RECEIPT, ESC + "|30uF");

		        if( posprinter1.CapRecBarCode)
			        posprinter1.PrintBarCode( PTR_S_RECEIPT, BcData, PTR_BCS_Code128, 100, 300, PTR_BC_CENTER, PTR_BC_TEXT_BELOW );
                posprinter1.TransactionPrint(PTR_S_RECEIPT, PTR_TP_NORMAL);
                //posprinter1.PrintNormal(PTR_S_RECEIPT, ESC + "|fP");
                this.lblInfo.Text = "Transaction Completed.";
                MessageBox.Show(this.lblInfo.Text);
                return;
	        }
            else if (sender == this.btnPageMode)
            {
                this.lblInfo.Text = "PageMode in  progressing...";

                double tPrice=0;
                int i;
                String sPrice;
                string[] aName = new string[5];
                float[] aPrice = new float[5];

                string strOutputData, BcData = "123456789012";
                // Make a data of the buying goods
                aName[0] = "apples"; aPrice[0] = 10;
                aName[1] = "grapes"; aPrice[1] = 20;
                aName[2] = "bananas"; aPrice[2] = 30;
                aName[3] = "lemons"; aPrice[3] = 40;
                aName[4] = "oranges"; aPrice[4] = 50;

                int lCount, iLineSpaceing, iBCHeight = 20;
                bool bBarcodePrint = posprinter1.CapRecBarCode;
                // PageMode
                posprinter1.PageModeStation = PTR_S_RECEIPT;
                posprinter1.PageModePrint(PTR_PM_PAGE_MODE);
                // Initialization of PageMode area
                int pWidth = Convert.ToInt32(posprinter1.PageModeArea.Substring(0, posprinter1.PageModeArea.IndexOf(','))); 
                posprinter1.PageModePrintArea = "0,0,"+pWidth.ToString().Trim() +",800";
                posprinter1.PageModeHorizontalPosition = 0;
                posprinter1.PageModeVerticalPosition = 0;

                posprinter1.PrintNormal(PTR_S_RECEIPT, ESC + "|N");

                strOutputData = "OPOS Store";
                lCount = (posprinter1.RecLineChars - (strOutputData.Length * 2)) / 4;
                for (i = lCount; i != 0; i--)
                {
                    strOutputData = " " + strOutputData + " ";
                }

                iLineSpaceing = 30;
                posprinter1.PageModeVerticalPosition += 2 * iLineSpaceing;
                posprinter1.PrintNormal(PTR_S_RECEIPT, ESC + "|4C" + ESC + "|cA" + ESC + "|2uC" + strOutputData + "\n");
                //posprinter1.PageModeHorizontalPosition = 200;
                posprinter1.PageModeVerticalPosition += 2 * iLineSpaceing;
                posprinter1.PrintNormal(PTR_S_RECEIPT, ESC + "|rA123xxStreet,xxCity,xxState" + "\n");
                posprinter1.PageModeVerticalPosition += iLineSpaceing;
                posprinter1.PrintNormal(PTR_S_RECEIPT, ESC + "|rATEL 9999-99-9999" + "\n");
                posprinter1.PageModeVerticalPosition += iLineSpaceing;
                posprinter1.PrintNormal(PTR_S_RECEIPT, ESC + "|rA" + System.DateTime.Now.ToString("yyyy-MM-dd") + "\n");
                for (i = 0; i < 5; i++)
                {
                    tPrice += aPrice[i];
                    sPrice = aPrice[i].ToString("$#.00").Trim();
                    posprinter1.PageModeVerticalPosition += iLineSpaceing;
                    posprinter1.PrintNormal(PTR_S_RECEIPT, aName[i]);
                    posprinter1.PrintNormal(PTR_S_RECEIPT, ESC + "|rA" + sPrice + "\n");
                }
                // Printing Barcode
                if (bBarcodePrint)
                {
                    iBCHeight = 100;
                    posprinter1.PageModeVerticalPosition += 2*iLineSpaceing + iBCHeight;
                    posprinter1.PrintBarCode(PTR_S_RECEIPT, BcData, PTR_BCS_Code128, iBCHeight,260, PTR_BC_CENTER, PTR_BC_TEXT_BELOW);
                }
                posprinter1.PageModePrint(PTR_PM_NORMAL);
                //posprinter1.PrintNormal(PTR_S_RECEIPT, ESC + "|fP");
                this.lblInfo.Text = "PageMode Completed.";
                MessageBox.Show(this.lblInfo.Text);
                return;
            }
            else if (sender == this.btnRotateMode)
            {
                this.lblInfo.Text = "RotatePrint in progressing...";

                long RotateType;
                
                String fDate;
                String BcData;
                bool bBitmapPrint = posprinter1.CapRecBitmap;
                bool bBarcodePrint = posprinter1.CapRecBarCode;

                RotateType = PTR_RP_BITMAP + PTR_RP_BARCODE;
                // Initialization
                fDate = System.DateTime.Now.ToString("yyyy-MM-dd");
                BcData = "1234567890";
                //Batch processing mode
                //Rotate 90
                posprinter1.RotatePrint(PTR_S_RECEIPT, (int)(PTR_RP_LEFT90 + RotateType));
                if (is58printer)
				{
					posprinter1.PrintNormal(PTR_S_RECEIPT, ESC + "|4C" + ESC + "|bCReceipt  " + ESC + "|3C  Mr. Brawn\n");
                	posprinter1.PrintNormal(PTR_S_RECEIPT, ESC + "|2uC                             \n");
                	posprinter1.PrintNormal(PTR_S_RECEIPT, fDate + " Received" + ESC + "|N             Phone#(9999)99-9998\n\n");
                	posprinter1.PrintNormal(PTR_S_RECEIPT, ESC + "|2uC" + ESC + "|3CTotal payment       $" + ESC + "|4C21.00");
                	posprinter1.PrintNormal(PTR_S_RECEIPT, ESC + "|1C" + "\n");

                	posprinter1.PrintNormal(PTR_S_RECEIPT, ESC + "|uC Details                      \n");
                	posprinter1.PrintNormal(PTR_S_RECEIPT, ESC + "|uC   Cloth                18.00 \n");
                	posprinter1.PrintNormal(PTR_S_RECEIPT, ESC + "|2uC   CDROM                 2.00 \n\n");
				}
				else
				{
                    posprinter1.PrintNormal(PTR_S_RECEIPT, ESC + "|2lF" + ESC + "|4C" + ESC + "|bCReceipt     " + ESC + "|3C           Mr. Brawn\n");
                    posprinter1.PrintNormal(PTR_S_RECEIPT, ESC + "|2uC                                                  \n");
                    posprinter1.PrintNormal(PTR_S_RECEIPT, fDate + " Received" + ESC + "|N           Phone#(9999)99-9998\n\n");
                    posprinter1.PrintNormal(PTR_S_RECEIPT, ESC + "|2uC" + ESC + "|3CTotal payment                         $" + ESC + "|4C21.00");
                    posprinter1.PrintNormal(PTR_S_RECEIPT, ESC + "|1C" + "\n");

                    posprinter1.PrintNormal(PTR_S_RECEIPT, ESC + "|uC Details                                          \n");
                    posprinter1.PrintNormal(PTR_S_RECEIPT, ESC + "|uC   Cloth                                    18.00 \n");
                    posprinter1.PrintNormal(PTR_S_RECEIPT, ESC + "|2uC   CDROM                                     2.00 \n\n");
                    posprinter1.PrintNormal(PTR_S_RECEIPT, ESC + "|!uC Receipt SN: " + BcData + "\n\n");
                }
				if (bBarcodePrint)
                {
                    posprinter1.PrintBarCode(PTR_S_RECEIPT, BcData, PTR_BCS_Code128, 50, 3, PTR_BC_CENTER, PTR_BC_TEXT_BELOW);
                }

                posprinter1.RotatePrint(PTR_S_RECEIPT, PTR_RP_NORMAL);
                //posprinter1.PrintNormal(PTR_S_RECEIPT, ESC + "|fP");
                this.lblInfo.Text = "RotatePrint Completed.";
                MessageBox.Show(this.lblInfo.Text);
            }
            else if (sender == this.btnAsync)
            {
                this.lblInfo.Text = "AsyncMode start";

                posprinter1.AsyncMode = true;
                posprinter1.PrintNormal(PTR_S_RECEIPT, "AsyncMode task:\"" + (posprinter1.OutputID).ToString().Trim() + "\" has completed.\n");
                posprinter1.PrintNormal(PTR_S_RECEIPT, "AsyncMode task:\"" + (posprinter1.OutputID).ToString().Trim() + "\" has completed.\n");
                posprinter1.PrintNormal(PTR_S_RECEIPT, "AsyncMode task:\"" + ( posprinter1.OutputID).ToString().Trim() + "\" has completed.\n");
                posprinter1.PrintNormal(PTR_S_RECEIPT, "AsyncMode task:\"" + (posprinter1.OutputID).ToString().Trim() + "\" has completed.\n");
                posprinter1.PrintNormal(PTR_S_RECEIPT, "AsyncMode task:\"" + (posprinter1.OutputID).ToString().Trim() + "\" has completed.\n");
                posprinter1.AsyncMode = false;
                this.lblInfo.Text = "AsyncMode Test Completed.";
                //MessageBox.Show(this.lblInfo.Text);
            }

        }
        private void Do_CashDrawer(object sender, EventArgs e)
        {
            if (!isOpenedCashDrawer)
            {
                OpenOposCashDrawer(strCashDrawer);
                if (!isOpenedCashDrawer)
                {
                    MessageBox.Show("Cann't control CashDrawer due to CashDrawer fail!");
                    return;
                }
            }
            if (sender == this.btnCashDrawerCheckHealth)
            {
                cashdrawer1.CheckHealth(OPOS_CH_INTERACTIVE);
                this.lblInfo.Text = cashdrawer1.CheckHealthText;
                MessageBox.Show(this.lblInfo.Text);
            }
            else if (sender == this.btnOpenDrawer)
            {
                int res=OPOS_SUCCESS;
                int count = 0;
                bool doAgain = true;
                while (doAgain)
                {
                    doAgain = false;
                    try
                    {
                        res = cashdrawer1.OpenDrawer();
                    }
                    catch
                    {
                        MessageBox.Show("Open CashDrawer Fail!");
                    }
                    count++;
                    if ((res == OPOS_E_BUSY) && count < 1000)
                    {
                        doAgain = true;
                    }
                }

                if (res == OPOS_SUCCESS) {
                    MessageBox.Show("Open CashDrawer Success!");

                } else {
                    if(cashdrawer1.ResultCodeExtended==OPOS_EPTR_COVER_OPEN)
                        MessageBox.Show("OpenDrawer Error.\r\nPrinter Cover Open");
                    else
                        MessageBox.Show("OpenDrawer Fail.\r\n"
                         + "Result:" + res.ToString()+"\r\n"
                         + "ResultCodeExtended:" + cashdrawer1.ResultCodeExtended.ToString() + "!");
                }
            }
            else if (sender == this.btnWaitForClose)
            {
                int res = OPOS_SUCCESS;
                if (cashdrawer1.CapStatus)
                {
                    res = cashdrawer1.WaitForDrawerClose(1000, 1000, 200, 200);
                    if (OPOS_SUCCESS == res)
                        MessageBox.Show("WaitForDrawerClose Success!");
                    else if (OPOS_E_TIMEOUT == res)
                        MessageBox.Show("TimeOut!");
                    else
                        MessageBox.Show("WaitForDrawerClose Fail.\r\n"
                         + "Result:" + res.ToString()
                         + "ResultCodeExtended:" + cashdrawer1.ResultCodeExtended.ToString() + "!");
                }
            }
            else if (sender == this.btnQueryDrawerStatus)
            {
                if (cashdrawer1.CapStatus)
                {
                    MessageBox.Show("CashDrawer is " + ((cashdrawer1.DrawerOpened) ? "opened!" : "closed!"));
                }
            }
        }
        private void FuncTest_FormClosing(object sender, FormClosingEventArgs e)
        {
            CloseOposCashDrawer();
            CloseOposPrinter();
        }

        private void btnClose_Click(object sender, EventArgs e)
        {
            Application.Exit();
        }

        private void posprinter1_OutputCompleteEvent(int outputID)
        {
            MessageBox.Show(String.Format("TaskID:\"{0}\" has completed!", outputID.ToString().Trim()));
        }
 
        private void printer_StatusUpdateEvent(int data)
        {
            if (data == PTR_SUE_REC_COVER_OPEN)
            {
                MessageBox.Show("Cover Opened!");
            }
            else if (data == PTR_SUE_REC_EMPTY)
            {
                MessageBox.Show("Paper Out!");
            }
            else if (data == PTR_SUE_REC_COVER_OK)
            {
                MessageBox.Show("Cover Closed!");
            }
            else if (data == PTR_SUE_REC_PAPEROK)
            {
                MessageBox.Show("Printer Ready!");
            }
            else if (data == PTR_SUE_REC_NEAREMPTY)
            {
                MessageBox.Show("Paper Near End!");
            }
            else
                MessageBox.Show("Printer StatusUpdate:" + data.ToString());
        }
        private void cashdrawer_StatusUpdateEvent(int data)
        {
            if (data == CASH_SUE_DRAWERCLOSED)
            {
                MessageBox.Show("CashDrawer Closed!");
            }
            else if (data == CASH_SUE_DRAWEROPEN)
            {
                MessageBox.Show("CashDrawer Opened!");
            }
            else
                MessageBox.Show("CashDrawer StatusUpdate:" + data.ToString());
        }
    }
}
